﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using Azyobuzi.りすにんぐついったー.Properties;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class SettingsForm : StylishForm
    {
        private SettingsForm()
        {
            InitializeComponent();

            //設定読み込み
            var s = SettingsXml.Instance;
            intervalBox.Value = s.interval;
            tempBox.Text = s.template;
        }

        private static SettingsForm f = new SettingsForm();
        public static void ShowForm()
        {
            f.Show();
        }

        private void authBtn_Click(object sender, EventArgs e)
        {
            using (var auth = new AuthForm()) 
            {
                auth.ShowDialog();
            }
        }

        private void cancelBtn_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void okBtn_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(tempBox.Text))
            {
                MessageBox.Show("投稿内容を入力してください。","入力エラー",MessageBoxButtons.OK,MessageBoxIcon.Error);
                return;
            }
            
            var s = SettingsXml.Instance;
            s.interval = (uint)intervalBox.Value;
            s.template = tempBox.Text;

            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void SettingsForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.Hide();
            }
        }

        private void detailBtn_Click(object sender, EventArgs e)
        {
            using (var f = new DetailSettingsForm())
            {
                f.ShowDialog(this);
            }
        }
    }
}
